#include <iostream>
#include <vector>
#include <limits>

using namespace std;

int main() {
    // Ucitavanje dimenzija matrice i podmatrice
    int N, M, K, L;
    cin >> N >> M >> K >> L;

    // Ucitavanje elemenata niza A
    vector<int> A(N * M);
    for (int i = 0; i < N * M; i++) {
        cin >> A[i];
    }

    // Inicijalizacija maksimalne sume
    long long maxSum = numeric_limits<long long>::min();

    // Prolazak kroz sve moguce pocetne tacke podmatrice
    for (int i = 0; i <= N - K; i++) {
        for (int j = 0; j <= M - L; j++) {
            // Racunanje sume podmatrice dimenzija KxL
            long long currentSum = 0;
            for (int x = i; x < i + K; x++) {
                for (int y = j; y < j + L; y++) {
                    currentSum += A[x * M + y];
                }
            }

            // Ažuriranje maksimalne sume
            maxSum = max(maxSum, currentSum);
        }
    }

    // Ispis rezultata
    cout << maxSum << endl;

    return 0;
}